<x-app-layout>
    <x-slot name="header">
        Package
    </x-slot>

    <!-- Row -->
    <div class="row">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">
                        @isset($package->id)
                        Edit Package
                        @else
                        Add New Package
                        @endisset
                    </div>
                </div>
                <form action="
                    @isset($package->id)
                        {{ route($role.'.package.update', $package->id) }}
                    @else
                        {{ route($role.'.package.store') }}
                    @endisset
                    " method="post" enctype="multipart/form-data">
                    <div class="card-body">
                        @isset($package->id)
                        @method('PUT')
                        @endisset
                        @csrf
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="name">Package Name :</label>
                            <div class="">
                                <input required type="search" class="form-control @error('name') is-invalid @enderror"
                                    name="name" value="{{ old('name', $package->name) }}" placeholder="Package Name">
                            </div>
                            @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="row mb-4">
                            <div class="col-lg-4">
                                <label class="form-label" id="adult_price">Price for adult :</label>
                                <div class="">
                                    <input required type="number"
                                        class="form-control @error('adult_price') is-invalid @enderror"
                                        name="adult_price" value="{{ old('adult_price', $package->adult_price) }}"
                                        placeholder="Price for adult">
                                </div>
                                @error('adult_price')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-lg-4">
                                <label class="form-label" id="child_price">Price for Child :</label>
                                <div class="">
                                    <input required type="number"
                                        class="form-control @error('child_price') is-invalid @enderror"
                                        name="child_price" value="{{ old('child_price', $package->child_price) }}"
                                        placeholder="Price for Child">
                                </div>
                                @error('child_price')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-lg-4">
                                <label class="form-label" id="infant_price">Price for Infant :</label>
                                <div class="">
                                    <input required type="number"
                                        class="form-control @error('infant_price') is-invalid @enderror"
                                        name="infant_price" value="{{ old('infant_price', $package->infant_price) }}"
                                        placeholder="Price for Infant">
                                </div>
                                @error('infant_price')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="row mb-4">
                            <div class="col-lg-4">
                                <label class="form-label" id="category_id">Category :</label>
                                <div class="">
                                    <select required name="category_id"
                                        class="form-control @error('category_id') is-invalid @enderror">
                                        <option value="">Select Category</option>
                                        @foreach ($categories as $category)
                                        <option value="{{ $category->id }}" @selected($category->id == old('category_id', $package->category_id))>{{ $category->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                @error('category_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-lg-4">
                                <label class="form-label" id="destination_id">Destination :</label>
                                <div class="">
                                    <select required name="destination_id"
                                        class="form-control @error('destination_id') is-invalid @enderror">
                                        <option value="">Select Destination</option>
                                        @foreach ($destinations as $destination)
                                        <option value="{{ $destination->id }}" @selected($destination->id == old('destination_id', $package->destination_id))>{{ $destination->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                @error('destination_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-lg-4">
                                <label class="form-label" id="start_date">Start Date :</label>
                                <div class="">
                                    <input required type="date"
                                        class="form-control @error('start_date') is-invalid @enderror"
                                        name="start_date" value="{{ old('start_date', $package->start_date?->format('Y-m-d')) }}"
                                        min="{{ date('Y-m-d') }}"
                                        placeholder="Start Date">
                                </div>
                                @error('start_date')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-4">
                                <label class="form-label" id="pickup_point">Pickup Point :</label>
                                <div class="">
                                    <input required type="search"
                                        class="form-control @error('pickup_point') is-invalid @enderror"
                                        name="pickup_point" value="{{ old('pickup_point', $package->pickup_point) }}"
                                        placeholder="Pickup Point">
                                </div>
                                @error('pickup_point')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-lg-4">
                                <label class="form-label" id="start_point">Start Point :</label>
                                <div class="">
                                    <input required type="search"
                                        class="form-control @error('start_point') is-invalid @enderror"
                                        name="start_point" value="{{ old('start_point', $package->start_point) }}"
                                        placeholder="Start Point">
                                </div>
                                @error('start_point')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-lg-4">
                                <label class="form-label" id="end_point">End Point :</label>
                                <div class="">
                                    <input required type="search"
                                        class="form-control @error('end_point') is-invalid @enderror"
                                        name="end_point" value="{{ old('end_point', $package->end_point) }}"
                                        placeholder="End Point">
                                </div>
                                @error('end_point')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="row mb-4">
                            <div class="col-lg-4">
                                <label class="form-label" id="min_people">Min Travelers:</label>
                                <div class="">
                                    <input required type="number"
                                        class="form-control @error('min_people') is-invalid @enderror"
                                        name="min_people" value="{{ old('min_people', $package->min_people) }}"
                                        placeholder="e.g. 10">
                                </div>
                                @error('min_people')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-lg-4">
                                <label class="form-label" id="max_people">Max Travelers :</label>
                                <div class="">
                                    <input required type="number"
                                        class="form-control @error('max_people') is-invalid @enderror"
                                        name="max_people" value="{{ old('max_people', $package->max_people) }}"
                                        placeholder="e.g. 100">
                                </div>
                                @error('max_people')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-lg-4">
                                <label class="form-label" id="duration">Tour Duration :</label>
                                <div class="">
                                    <input required type="search"
                                        class="form-control @error('duration') is-invalid @enderror"
                                        name="duration" value="{{ old('duration', $package->duration) }}"
                                        placeholder="e.g. 5 days 4 nights">
                                </div>
                                @error('duration')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="video">Youtube Video :</label>
                            <div class="">
                                <input type="url" class="form-control @error('video') is-invalid @enderror"
                                    name="video" value="{{ old('video', $package->video) }}"
                                    placeholder="Enter youtube link">
                            </div>
                            @error('video')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row mb-4">
                            <x-dynamic-input
                                :items="old('inclusions', $package->inclusions)??[]"
                                name="inclusions"
                                placeholder="Enter a included facility"
                                buttonText="Included Facility"
                            />
                        </div>
                        <div class="row mb-4">
                            <x-dynamic-input
                                :items="old('exclusions', $package->exclusions)??[]"
                                name="exclusions"
                                placeholder="Enter a excluded facility"
                                buttonText="Excluded Facility"
                            />
                        </div>
                        <div class="row mb-4">
                            <x-dynamic-input
                                :items="old('we_expect', $package->we_expect)??[]"
                                name="we_expect"
                                placeholder="Enter a expectation"
                                buttonText="What we expect"
                            />
                        </div>
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="thumbnail">Thumbnail :</label>
                            <div class="">
                                <input  @if(!isset($package->id))required @endif type="file" class="form-control @error('thumbnail') is-invalid @enderror"
                                    name="thumbnail" value="{{ old('thumbnail', $package->thumbnail) }}"
                                    placeholder="Package thumbnail" accept=".jpg, .png, image/jpeg, image/png">
                            </div>
                            @error('thumbnail')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="description">Package Details:</label>
                            <div class="">
                                <textarea required name="description" class="content @error('description') is-invalid @enderror"
                                    placeholder="Package description">{{ old('description', $package->description) }}</textarea>
                            </div>
                            @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>


                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="gallery">Gallery (min 3 images) :</label>
                            <div class="">
                                <input @if(!isset($package->id))required @endif multiple type="file" class="form-control @error('gallery') is-invalid @enderror"
                                    name="gallery[]" value="{{ old('gallery', $package->gallery) }}"
                                    placeholder="Package gallery" accept=".jpg, .png, image/jpeg, image/png">
                            </div>
                            @error('gallery')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <label class="custom-switch form-switch me-5">
                            <input type="checkbox" name="status" value="1" class="custom-switch-input" {{ old('status',
                                $package->status) == 1 ? 'checked' : '' }}>
                            <span class="custom-switch-indicator custom-switch-indicator-lg"></span>
                            <span class="custom-switch-description">Status</span>
                        </label>
                        @if ($role == 'admin')
                        <label class="custom-switch form-switch me-5">
                            <input type="checkbox" name="published" value="1" class="custom-switch-input" {{ old('published',
                                $package->published) == 1 ? 'checked' : '' }}>
                            <span class="custom-switch-indicator custom-switch-indicator-lg"></span>
                            <span class="custom-switch-description">Published</span>
                        </label>
                        <label class="custom-switch form-switch me-5">
                            <input type="checkbox" name="featured" value="1" class="custom-switch-input" {{ old('featured',
                                $package->featured) == 1 ? 'checked' : '' }}>
                            <span class="custom-switch-indicator custom-switch-indicator-lg"></span>
                            <span class="custom-switch-description">Featured</span>
                        </label>
                        @endif
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Save</button>
                        <a href="{{route($role.'.package.index')}}" class="btn btn-default float-end">Discard</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Row -->
    <x-slot name="script">
        <script src="{{asset('backend/plugins/wysiwyag/jquery.richtext.js')}}"></script>
        <script src="{{asset('backend/plugins/wysiwyag/wysiwyag.js')}}"></script>
        <script>
            $(document).ready(function () {
            });
        </script>
    </x-slot>

</x-app-layout>
